/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.ipp;

import com.visigenic.vbroker.util.ipp.Token;
import java.util.Dictionary;
import java.util.Hashtable;

public class Delimiter
extends Token {
    private static Dictionary _delimiters = new Hashtable();
    private String _name;
    private int _contained_sym;

    private Delimiter(int n, String string, int n2) {
        super(n, n2);
        this._name = string;
        this._contained_sym = -1;
    }

    Object value() {
        return this._name;
    }

    Delimiter(int n) {
        super(n);
        this._contained_sym = -1;
    }

    void initDelimiter(Delimiter delimiter) {
        this.initToken(delimiter);
        this._name = (String)delimiter.value();
        this._contained_sym = delimiter.getSym();
    }

    int contained_sym() {
        return this._contained_sym;
    }

    static Token get(String string, int n) {
        Delimiter delimiter = (Delimiter)_delimiters.get(string);
        if (delimiter == null) {
            throw new RuntimeException("Invalid delimiter: " + string);
        }
        return new Delimiter(delimiter.sym, string, n);
    }

    private static void add(int n, String string) {
        if (_delimiters.get(string) != null) {
            throw new RuntimeException("Duplicate delimiter: " + string);
        }
        _delimiters.put(string, new Delimiter(n, string, -1));
    }

    static {
        Delimiter.add(35, "#");
        Delimiter.add(36, "(");
        Delimiter.add(37, ")");
        Delimiter.add(38, ",");
        Delimiter.add(39, "\n");
        Delimiter.add(40, "`");
        Delimiter.add(41, "\\");
        Delimiter.add(42, "@");
        Delimiter.add(43, "$");
        Delimiter.add(44, "[");
        Delimiter.add(45, "]");
        Delimiter.add(46, "{");
        Delimiter.add(47, "}");
        Delimiter.add(48, "?");
        Delimiter.add(49, ";");
        Delimiter.add(50, ".");
        Delimiter.add(51, ":");
        Delimiter.add(52, "::");
    }
}

